/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.16
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-10-29, 18:58, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE ProcessorExpert */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "FMSTR1.h"
#include "FMSTR_JTAG_RX1.h"
#include "FMSTR_JTAG_TX1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* Including FTFL library functions */
#include "SSD_Types.h"
#include "SSD_FTFL.h"
#include "SSD_FTFL_Internal.h"

/* Macro definition */
#define  SIZE_OF_BYTES	0x100 //4	 	// must be multiple of longwords

/* Global variables definition */
FLASH_SSD_CONFIG ftfl_cfg = {
	                        	FTFL_REG_BASE, //
	                            PFLASH_BLOCK_BASE,
	                            PBLOCK_SIZE,
	                            DEFLASH_BLOCK_BASE,
	                            0,
	                            EERAM_BLOCK_BASE,
	                            EERAM_BLOCK_SIZE,
	                            0,
	                            0,
	                            NULL_CALLBACK
							};

/* Global variables definition @ EEPROM space */
#pragma define_section EEPROMData ".eepromData"  RW
#pragma section EEPROMData begin
INT8 eedata[SIZE_OF_BYTES];  
#pragma section EEPROMData end

INT8 source[SIZE_OF_BYTES];
INT8 eeewrten=0;

void main(void)
{
  /* Write your local variable definition here */
  UINT16 size,index;
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Initialize Flash to get the EEPROM information */
  FlashInit(&ftfl_cfg);
  
  /* Enable EEPROM space */
  if(ftfl_cfg.EEEBlockSize == EEESIZE_1111)		//Check if DFlash EEPROM backup exists
  {
	  DEFlashPartition(&ftfl_cfg, 0x36U, 0x02, FlashCommandSequence);		//0x36: 256bytes EEPROM data size, 0x02: 16kbytes EEPROM buckup size 
	  SetEEEEnable(&ftfl_cfg, 0x00U);		//Configure FlexRAM available for EEPROM
  }
  
  /* Initialize the EEPROM space */
  for(index=0;index<SIZE_OF_BYTES;index++)
  {
	  source[index] = 255-index;
  }
  
  /* Write your code here */

  for(;;) 
  {
	  
	  if((eeewrten == 1) && (TEST8(ftfl_cfg.ftflRegBase + FTFL_FEPROT_OFFSET, 0xFF) == 0xFF))
	  {
		  size = SIZE_OF_BYTES;
		  index = 0;
		  FTFL_FSTAT &= 0x10;		//Clear Flash protection violation flag
		  while(size>0)
		  {
			  while(FALSE == REG_BIT_TEST(ftfl_cfg.ftflRegBase + FTFL_FCNFG_OFFSET, FTFL_FCNFG_EEERDY))
			  {
				  /* wait till EEERDY bit is set */
			  }
			  /* 8-bit data write */
		  	  WRITE8(eedata+index, source[index]);
		  	  index += 1;
		  	  size -= 1;
		  	  /* 16-bit data write */
		  	  //WRITE16(((UINT32)eedata+index)>>1, *(UINT16*)(source+index));
		  	  //index +=2;
		  	  //size -=2;
		  	  /* 32-bit data write */
		  	  //WRITE32(((UINT32)eedata+index)>>1, *(UINT32*)(source+index));
		  	  //index += 4;
		  	  //size -= 4;
		  }
		  eeewrten = 0;
	  }
	  
	  FMSTR1_Poll();
  }
}

/* END ProcessorExpert */
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.0 [05.02]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
